---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：28-Fast Refreshフルリロード通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **REACT_REFRESH_FULL_RELOAD定数の定義場所**：shared.tsの正確な行番号未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/messages.ts` 7-8行目 FAST_REFRESH_RUNTIME_RELOAD定数
- E-02: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 990-1006行目 client-full-reload処理
- E-03: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 116-138行目 performFullReload
- E-04: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 153-161行目 handleApplyUpdates
- E-05: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 391-394行目 TURBOPACK_MESSAGE受信時

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 定数メッセージは`"Fast Refresh had to perform a full reload due to a runtime error."` | E-01 | ○ |
| C-02 | サーバー側で`hadRuntimeError`フラグ判定 | E-02 | ○ |
| C-03 | サーバー側で`Log.warn(FAST_REFRESH_RUNTIME_RELOAD)`出力 | E-02 | ○ |
| C-04 | `dependencyChain`がある場合にモジュールパス付きメッセージ | E-02 | ○ |
| C-05 | モジュールパスの`[project]`プレフィックス除去 | E-02 | ○ |
| C-06 | ブラウザ側で`performFullReload`実行 | E-03 | ○ |
| C-07 | `client-full-reload`イベントをサーバーに送信 | E-03 | ○ |
| C-08 | HMR適用失敗時に`REACT_REFRESH_FULL_RELOAD`をconsole.warn | E-04 | ○ |
| C-09 | TURBOPACK_MESSAGE受信時にランタイムエラーがあればフルリロード | E-05 | ○ |
| C-10 | `window.location.reload()`でフルリロード実行 | E-03 | ○ |
| C-11 | `reloading`フラグで二重リロード防止 | E-03 | ○ |
| C-12 | `REACT_REFRESH_FULL_RELOAD`と`REACT_REFRESH_FULL_RELOAD_FROM_ERROR`の使い分け | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- `REACT_REFRESH_FULL_RELOAD`と`REACT_REFRESH_FULL_RELOAD_FROM_ERROR`の正確な定義箇所と文字列内容
  - 候補：`packages/next/src/client/dev/hot-reloader/shared.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サーバー側ロジックは明確
- 0: 低リスク - ブラウザ側ロジックも明確
- 1: 中リスク - 2種類のメッセージ定数の使い分けの詳細要確認

## 6) レビュアーチェックリスト（最小）
- [ ] `REACT_REFRESH_FULL_RELOAD`と`REACT_REFRESH_FULL_RELOAD_FROM_ERROR`の使い分けを確認
- [ ] `dependencyChain`のモジュールパス整形ロジックが正しいか確認
- [ ] Pages RouterとApp Routerでの`performFullReload`の差異を確認
